#region References

using System;
using System.Collections;
using System.Data;
using System.Text;
using gov.va.med.vbecs.Common;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;
using SPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;
using BLOODUNITREPORTSUMMARY = gov.va.med.vbecs.Common.DatabaseConstants.BloodUnitReportSummary;
using REPORT_TABLES = gov.va.med.vbecs.Common.DatabaseConstants.BloodUnitReportTables;

#endregion

namespace gov.va.med.vbecs.BOL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>David Askew</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>10/07/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Business object component providing functionality for
	///	blood unit history report
	///</summary>

	#endregion

	public class BloodUnitReport : VbecsReport
	{
		#region Variables

		/// <summary>
		/// Used to hold the message we will display after the report criteria
		/// indicating those sections the user requested but which contained no
		/// data
		/// </summary>
		private string _message = "";

		/// <summary>
		/// Used to indicate whether exception report data was returned;
		/// we will show warning in _message if there was not any data returned  
		/// </summary>
		private int _exceptionReportRowCount;
        private DataSet _reportData;

		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6214"> 
		///		<ExpectedInput>Valid Guid Value</ExpectedInput>
		///		<ExpectedOutput>Valid Guid Value passed in.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6215"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// BloodUnitGuid
		/// </summary>
		public Guid BloodUnitGuid
		{
			get 
			{
				return (Guid)this.ParameterRow[TABLE.BloodUnit.BloodUnitGuid];
			}
			set
			{
				this.ParameterRow[TABLE.BloodUnit.BloodUnitGuid] = value;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6216"> 
		///		<ExpectedInput>Valid string value.</ExpectedInput>
		///		<ExpectedOutput>String value passed in.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6217"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// EyeReadableUnitId
		/// </summary>
		public string EyeReadableUnitId
		{
			get 
			{
				return Convert.ToString( this.ParameterRow[TABLE.BloodUnit.EyeReadableUnitId] );
			}
			set
			{
				this.ParameterRow[TABLE.BloodUnit.EyeReadableUnitId] = value;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6218"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6219"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ProductCode
		/// </summary>
		public string ProductCode
		{
			get 
			{
				return Convert.ToString( this.ParameterRow[TABLE.BloodProduct.ProductCode] );
			}
			set
			{
				this.ParameterRow[TABLE.BloodProduct.ProductCode] = value;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6220"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6221"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ReportsSelected
		/// </summary>
		public int ReportsSelected
		{
			get 
			{
				int count = 0;

				count += (this.IncludeAntigenTypingReport ? 1 : 0);
				count += (this.IncludeBloodUnitTestingReport ? 1 : 0);
				count += (this.IncludeCrossmatchTestingReport ? 1 : 0);
				count += (this.IncludeRestrictedPatientReport ? 1 : 0);
				count += (this.IncludeExceptionReport ? 1 : 0);
				count += (this.IncludeFinanceReport ? 1 : 0);
				count += (this.IncludeIncomingShipmentReport ? 1 : 0);
				count += (this.IncludeIssueReport ? 1 : 0);
				count += (this.IncludeModificationReport ? 1 : 0);
				count += (this.IncludeOutgoingShipmentReport ? 1 : 0);
				count += (this.IncludePatientAssociationReport ? 1 : 0);
				count += (this.IncludeStatusReport ? 1 : 0);
				count += (this.IncludeTransfusionReport ? 1 : 0);

				return count;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6222"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6223"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IncludeIncomingShipmentReport
		/// </summary>
		public bool IncludeIncomingShipmentReport
		{
			get 
			{
				return Convert.ToBoolean(this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeIncomingShipmentReport]);
			}
			set
			{
				this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeIncomingShipmentReport] = value;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6224"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6225"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IncludeOutgoingShipmentReport
		/// </summary>
		public bool IncludeOutgoingShipmentReport
		{
			get 
			{
				return Convert.ToBoolean(this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeOutgoingShipmentReport]);
			}
			set
			{
				this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeOutgoingShipmentReport] = value;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6226"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6227"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		/// IncludeAnitgenTypingReport
		/// </summary>
		public bool IncludeAntigenTypingReport
		{
			get 
			{
				return Convert.ToBoolean(this.ParameterRow[ARTIFICIAL.IncludeAntigenTypingReport]);
			}
			set
			{
				this.ParameterRow[ARTIFICIAL.IncludeAntigenTypingReport] = value;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6228"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6229"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IncludeRestrictedPatientReport
		/// </summary>
		public bool IncludeRestrictedPatientReport
		{
			get 
			{
				return Convert.ToBoolean(this.ParameterRow[ARTIFICIAL.IncludeRestrictedPatientReport]);
			}
			set
			{
				this.ParameterRow[ARTIFICIAL.IncludeRestrictedPatientReport] = value;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6230"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6231"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IncludeStatusReport
		/// </summary>
		public bool IncludeStatusReport
		{
			get 
			{
				return Convert.ToBoolean(this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeStatusReport]);
			}
			set
			{
				this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeStatusReport] = value;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6232"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6233"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IncludeFinanceReport
		/// </summary>
		public bool IncludeFinanceReport
		{
			get 
			{
				return Convert.ToBoolean(this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeFinanceReport]);
			}
			set
			{
				this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeFinanceReport] = value;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6234"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6235"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IncludePatientAssociationReport
		/// </summary>
		public bool IncludePatientAssociationReport
		{
			get 
			{
				return Convert.ToBoolean(this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludePatientAssociationReport]);
			}
			set
			{
				this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludePatientAssociationReport] = value;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6236"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6237"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		/// IncludeIssueReport
		/// </summary>
		public bool IncludeIssueReport
		{
			get 
			{
				return Convert.ToBoolean(this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeIssueReport]);
			}
			set
			{
				this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeIssueReport] = value;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6238"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6239"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IncludeBloodUnitTestingReport
		/// </summary>
		public bool IncludeBloodUnitTestingReport
		{
			get 
			{
				return Convert.ToBoolean(this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeBloodUnitTestingReport]);
			}
			set
			{
				this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeBloodUnitTestingReport] = value;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6240"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6241"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IncludeCrossmatchTestingReport
		/// </summary>
		public bool IncludeCrossmatchTestingReport
		{
			get 
			{
				return Convert.ToBoolean(this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeCrossmatchTestingReport]);
			}
			set
			{
				this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeCrossmatchTestingReport] = value;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6242"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6243"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IncludeModificationReport
		/// </summary>
		public bool IncludeModificationReport
		{
			get 
			{
				return Convert.ToBoolean(this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeModificationReport]);
			}
			set
			{
				this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeModificationReport] = value;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6244"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6245"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IncludeTransfusionReport
		/// </summary>
		public bool IncludeTransfusionReport
		{
			get 
			{
				return Convert.ToBoolean(this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeTransfusionReport]);
			}
			set
			{
				this.ParameterRow[BLOODUNITREPORTSUMMARY.IncludeTransfusionReport] = value;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6246"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6247"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IncludeExceptionReport
		/// </summary>
		public bool IncludeExceptionReport
		{
			get 
			{
				return Convert.ToBoolean(this.ParameterRow[ARTIFICIAL.IncludeExceptionReport]);
			}
			set
			{
				this.ParameterRow[ARTIFICIAL.IncludeExceptionReport] = value;
			}
		}

		#endregion

		#region Constructors

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5759"> 
		///		<ExpectedInput>BloodUnit Guid</ExpectedInput>
		///		<ExpectedOutput>BloodUnitReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5760"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor
		/// </summary>
		public BloodUnitReport(Guid bloodUnitGuid)
		{
			BloodUnitGuid = bloodUnitGuid;
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/13/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6248"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6249"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Constructor
		/// </summary>
		public BloodUnitReport()
		{
			this.BloodUnitGuid=Guid.Empty;

			this.EyeReadableUnitId=String.Empty;
			this.ProductCode=String.Empty;

			this.IncludeIncomingShipmentReport=false;
			this.IncludeOutgoingShipmentReport=false;
			this.IncludeAntigenTypingReport=false;
			this.IncludeRestrictedPatientReport=false;
			this.IncludeStatusReport=false;
			this.IncludeFinanceReport=false;
			this.IncludePatientAssociationReport=false;
			this.IncludeIssueReport=false;
			this.IncludeBloodUnitTestingReport=false;
			this.IncludeCrossmatchTestingReport=false;
			this.IncludeModificationReport=false;
			this.IncludeTransfusionReport=false;
			this.IncludeExceptionReport=false;
		}

		#endregion

		#region Static Methods

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5755"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5756"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetBloodUnitsForHistoryReport
		/// </summary>
		public static DataTable GetBloodUnitsForHistoryReport()
		{
			return DAL.BloodUnitReport.GetBloodUnitsForHistoryReport();
		}

		///<Developers>
		///	<Developer>D. Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/9/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8371"> 
		///		<ExpectedInput>BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>Int value</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8372"> 
		///		<ExpectedInput>Invalid BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>0</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns estimated record count for the unit history report
		/// </summary>
		public static int GetReportBloodUnitHistoryRecordCount
		(
			Guid bloodUnitGuid,
			bool includeIncomingShipmentReport,
			bool includeOutgoingShipmentReport,
			bool includeAntigenTypingReport,
			bool includeRestrictedPatientReport,
			bool includeStatusReport,
			bool includeFinanceReport,
			bool includePatientAssociationReport,
			bool includeIssueReport,
			bool includeBloodUnitTestingReport,
			bool includeCrossmatchTestingReport,
			bool includeModificationReport,
			bool includeTransfusionReport,
			bool includeExceptionReport
		)
		{
			return DAL.BloodUnitReport.GetReportBloodUnitHistoryRecordCount
			(
				bloodUnitGuid,
				includeIncomingShipmentReport,
				includeOutgoingShipmentReport,
				includeAntigenTypingReport,
				includeRestrictedPatientReport,
				includeStatusReport,
				includeFinanceReport,
				includePatientAssociationReport,
				includeIssueReport,
				includeBloodUnitTestingReport,
				includeCrossmatchTestingReport,
				includeModificationReport,
				includeTransfusionReport,
				includeExceptionReport
			);
		}

		#endregion

		#region Instance Methods

		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/8/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7398"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7399"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generate and print report
		/// Used by VbecsConsoleReport application
		/// </summary>
        protected override VbecsReportPrinter createReportPrinter()
		{
            _reportData = this.GetReportTables();
            BOL.VbecsUser user = new BOL.VbecsUser(this.PrintedBy);

            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(user.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this.GetReportCriteria());

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.BloodUnitHistorySummary].Rows.Count > 0)
            {
                reportSourceMain.Name = "BloodUnitHistoryDataSet";
                reportSourceMain.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.BloodUnitHistorySummary];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }
            Assembly assembly = Assembly.LoadFrom(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + "\\Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitHistoryReportMain.rdlc");
            Stream streamIncomingShipment = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitIncomingShipmentHistory.rdlc");
            Stream streamOutgoingShipment = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitOutgoingShipmentHistory.rdlc");
            Stream streamAntigenTyping = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitAntigenTypingHistory.rdlc");
            Stream streamRestrictedPatient = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitRestrictedPatientHistory.rdlc");
            Stream streamStatus = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitStatusHistory.rdlc");
            Stream streamFinance = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitFinancialHistory.rdlc");
            Stream streamPatientAssociation = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitPatientAssociationHistory.rdlc");
            Stream streamIssue = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitIssueHistory.rdlc");
            Stream streamTesting = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitTestingHistory.rdlc");
            Stream streamCrossmatch = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitCrossmatchTestingHistory.rdlc");
            Stream streamModificationOriginalUnits = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitModificationOriginalUnitsHistory.rdlc");
            Stream streamModificationTargetUnits = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitModificationTargetUnitsHistory.rdlc");
            Stream streamModification = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitModificationHistory.rdlc");
            Stream streamModificationEquipment = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitModificationEquipmentHistory.rdlc");
            Stream streamTransfusion = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodUnitHistoryReport.BloodUnitTransfusionHistory.rdlc");
            Stream streamExceptionAntigenTest = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionAntigenTest.rdlc");
            Stream streamExceptionExpiredUnit = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionExpiredUnit.rdlc");
            Stream streamExceptionLabelMismatch = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionLabelMismatch.rdlc");
            Stream streamExceptionQuarantine = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionQuarantine.rdlc");
            Stream streamExceptionRemoveFinalUnitStatus = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionRemoveFinalUnitStatus.rdlc");
            Stream streamExceptionReturnIssuedUnit = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionReturnIssuedUnit.rdlc");
            Stream streamExceptionUnitAboRh = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitAboRh.rdlc");
            Stream streamExceptionUnitModification = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitModification.rdlc");
            Stream streamExceptionUnitSelection = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitSelection.rdlc");
            Stream streamExceptionUnitSupply = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitSupply.rdlc");
            Stream streamExceptionQC = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionQC.rdlc");

            LocalReport report = new LocalReport();

            report.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            report.DataSources.Add(reportSourceMain);
            report.DataSources.Add(reportSourceHeader);
            report.DataSources.Add(reportSourceFooter);
            report.LoadReportDefinition(stream);
            report.LoadSubreportDefinition("BloodUnitIncomingShipmentHistory", streamIncomingShipment);
            report.LoadSubreportDefinition("BloodUnitOutgoingShipmentHistory", streamOutgoingShipment);
            report.LoadSubreportDefinition("BloodUnitAntigenTypingHistory", streamAntigenTyping);
            report.LoadSubreportDefinition("BloodUnitRestrictedPatientHistory", streamRestrictedPatient);
            report.LoadSubreportDefinition("BloodUnitStatusHistory", streamStatus);
            report.LoadSubreportDefinition("BloodUnitFinancialHistory", streamFinance);
            report.LoadSubreportDefinition("BloodUnitPatientAssociationHistory", streamPatientAssociation);
            report.LoadSubreportDefinition("BloodUnitIssueHistory", streamIssue);
            report.LoadSubreportDefinition("BloodUnitTestingHistory", streamTesting);
            report.LoadSubreportDefinition("BloodUnitCrossmatchTestingHistory", streamCrossmatch);
            report.LoadSubreportDefinition("BloodUnitModificationOriginalUnitsHistory", streamModificationOriginalUnits);
            report.LoadSubreportDefinition("BloodUnitModificationTargetUnitsHistory", streamModificationTargetUnits);
            report.LoadSubreportDefinition("BloodUnitModificationHistory", streamModification);
            report.LoadSubreportDefinition("BloodUnitModificationEquipmentHistory", streamModificationEquipment);
            report.LoadSubreportDefinition("BloodUnitTransfusionHistory", streamTransfusion);
            report.LoadSubreportDefinition("ExceptionAntigenTest", streamExceptionAntigenTest);
            report.LoadSubreportDefinition("ExceptionExpiredUnit", streamExceptionExpiredUnit);
            report.LoadSubreportDefinition("ExceptionLabelMismatch", streamExceptionLabelMismatch);
            report.LoadSubreportDefinition("ExceptionQuarantine", streamExceptionQuarantine);
            report.LoadSubreportDefinition("ExceptionRemoveFinalUnitStatus", streamExceptionRemoveFinalUnitStatus);
            report.LoadSubreportDefinition("ExceptionReturnIssuedUnit", streamExceptionReturnIssuedUnit);
            report.LoadSubreportDefinition("ExceptionUnitAboRh", streamExceptionUnitAboRh);
            report.LoadSubreportDefinition("ExceptionUnitModification", streamExceptionUnitModification);
            report.LoadSubreportDefinition("ExceptionUnitSelection", streamExceptionUnitSelection);
            report.LoadSubreportDefinition("ExceptionUnitSupply", streamExceptionUnitSupply);
            report.LoadSubreportDefinition("ExceptionQC", streamExceptionQC);

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.IncomingShipmentReport) < 0 ||
                this.IncludeIncomingShipmentReport == false)
                report.SetParameters(new ReportParameter("HideIncomingShipment", "true"));
            else
                report.SetParameters(new ReportParameter("HideIncomingShipment", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.OutgoingShipmentReport) < 0 ||
                this.IncludeOutgoingShipmentReport == false)
                report.SetParameters(new ReportParameter("HideOutgoingShipment", "true"));
            else
                report.SetParameters(new ReportParameter("HideOutgoingShipment", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.AntigenTypingReport) < 0 ||
              this.IncludeAntigenTypingReport == false)
                report.SetParameters(new ReportParameter("HideAntigenTyping", "true"));
            else
                report.SetParameters(new ReportParameter("HideAntigenTyping", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.DirectedPatientReport) < 0 ||
                this.IncludeRestrictedPatientReport == false)
                report.SetParameters(new ReportParameter("HideRestrictedPatient", "true"));
            else
                report.SetParameters(new ReportParameter("HideRestrictedPatient", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.StatusReport) < 0 ||
               this.IncludeStatusReport == false)
                report.SetParameters(new ReportParameter("HideStatus", "true"));
            else
                report.SetParameters(new ReportParameter("HideStatus", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.FinanceReport) < 0 ||
               this.IncludeFinanceReport == false)
                report.SetParameters(new ReportParameter("HideFinance", "true"));
            else
                report.SetParameters(new ReportParameter("HideFinance", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.PatientAssociationReport) < 0 ||
               this.IncludePatientAssociationReport == false)
                report.SetParameters(new ReportParameter("HidePatientAssociation", "true"));
            else
                report.SetParameters(new ReportParameter("HidePatientAssociation", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.IssueReport) < 0 ||
               this.IncludeIssueReport == false)
                report.SetParameters(new ReportParameter("HideIssue", "true"));
            else
                report.SetParameters(new ReportParameter("HideIssue", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.BloodUnitTestingReport) < 0 ||
              this.IncludeBloodUnitTestingReport == false)
                report.SetParameters(new ReportParameter("HideTesting", "true"));
            else
                report.SetParameters(new ReportParameter("HideTesting", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.CrossmatchTestingReport) < 0 ||
              this.IncludeCrossmatchTestingReport == false)
                report.SetParameters(new ReportParameter("HideCrossmatch", "true"));
            else
                report.SetParameters(new ReportParameter("HideCrossmatch", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.OriginalUnitsFromModification) < 0 ||
             this.IncludeModificationReport == false)
                report.SetParameters(new ReportParameter("HideOriginalUnits", "true"));
            else
                report.SetParameters(new ReportParameter("HideOriginalUnits", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.TargetUnitsFromModification) < 0 ||
             this.IncludeModificationReport == false)
                report.SetParameters(new ReportParameter("HideTargetUnits", "true"));
            else
                report.SetParameters(new ReportParameter("HideTargetUnits", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.ModificationReport) < 0 ||
            this.IncludeModificationReport == false)
                report.SetParameters(new ReportParameter("HideModification", "true"));
            else
                report.SetParameters(new ReportParameter("HideModification", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.ModificationEquipmentAndSupplies) < 0 ||
           this.IncludeModificationReport == false)
                report.SetParameters(new ReportParameter("HideEquipment", "true"));
            else
                report.SetParameters(new ReportParameter("HideEquipment", "false"));

            if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.TransfusionReport) < 0 ||
                this.IncludeTransfusionReport == false)
                report.SetParameters(new ReportParameter("HideTransfusion", "true"));
            else
                report.SetParameters(new ReportParameter("HideTransfusion", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionAntigenTest") < 0 ||
               this.IncludeExceptionReport == false)
                report.SetParameters(new ReportParameter("HideExceptionAntigenTest", "true"));
            else
                report.SetParameters(new ReportParameter("HideExceptionAntigenTest", "false"));

            if (this._reportData.Tables.IndexOf("GetExceptionReportExpiredUnitReceived") < 0 ||
               this.IncludeExceptionReport == false)
                report.SetParameters(new ReportParameter("HideExceptionExpiredUnit", "true"));
            else
                report.SetParameters(new ReportParameter("HideExceptionExpiredUnit", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionReportLabelMismatch") < 0 ||
               this.IncludeExceptionReport == false)
                report.SetParameters(new ReportParameter("HideExceptionLabelMismatch", "true"));
            else
                report.SetParameters(new ReportParameter("HideExceptionLabelMismatch", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionReportQuarantine") < 0 ||
               this.IncludeExceptionReport == false)
                report.SetParameters(new ReportParameter("HideExceptionQuarantine", "true"));
            else
                report.SetParameters(new ReportParameter("HideExceptionQuarantine", "false"));

            if (this._reportData.Tables.IndexOf(Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus.ToString()) < 0 ||
               this.IncludeExceptionReport == false)
                report.SetParameters(new ReportParameter("HideExceptionRemoveFinalUnitStatus", "true"));
            else
                report.SetParameters(new ReportParameter("HideExceptionRemoveFinalUnitStatus", "false"));

            if (this._reportData.Tables.IndexOf(Common.ExceptionReportType.ExceptionReportReturnIssuedUnit.ToString()) < 0 ||
              this.IncludeExceptionReport == false)
                report.SetParameters(new ReportParameter("HideExceptionReturnIssuedUnit", "true"));
            else
                report.SetParameters(new ReportParameter("HideExceptionReturnIssuedUnit", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionReportUnitAboRh") < 0 ||
             this.IncludeExceptionReport == false)
                report.SetParameters(new ReportParameter("HideExceptionUnitAboRh", "true"));
            else
                report.SetParameters(new ReportParameter("HideExceptionUnitAboRh", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionReportUnitModification") < 0 ||
            this.IncludeExceptionReport == false)
                report.SetParameters(new ReportParameter("HideExceptionUnitModification", "true"));
            else
                report.SetParameters(new ReportParameter("HideExceptionUnitModification", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionReportUnitSelection") < 0 ||
            this.IncludeExceptionReport == false)
                report.SetParameters(new ReportParameter("HideExceptionUnitSelection", "true"));
            else
                report.SetParameters(new ReportParameter("HideExceptionUnitSelection", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionReportUnitSupplyForBloodUnit") < 0 ||
            this.IncludeExceptionReport == false)
                report.SetParameters(new ReportParameter("HideExceptionUnitSupply", "true"));
            else
                report.SetParameters(new ReportParameter("HideExceptionUnitSupply", "false"));

            if (this._reportData.Tables.IndexOf("ExceptionReportQC") < 0 ||
            this.IncludeExceptionReport == false)
                report.SetParameters(new ReportParameter("HideExceptionQC", "true"));
            else
                report.SetParameters(new ReportParameter("HideExceptionQC", "false"));
             
            return new VbecsReportPrinter(this.PrinterName, true, report);
        }

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "BloodUnitIncomingShipmentHistory" || e.DataSourceNames[0].ToString() == "BloodUnitIncomingShipmentDataSet")
            {
                ReportDataSource reportSourceIncomingShipment = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.IncomingShipmentReport) >= 0)
                {
                    reportSourceIncomingShipment.Name = "BloodUnitIncomingShipmentDataSet";
                    reportSourceIncomingShipment.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.IncomingShipmentReport];
                }
                e.DataSources.Add(reportSourceIncomingShipment);
            }
            else if (e.ReportPath == "BloodUnitOutgoingShipmentHistory" || e.DataSourceNames[0].ToString() == "BloodUnitOutgoingShipmentDataSet")
            {
                ReportDataSource reportSourceOutgoingShipment = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.OutgoingShipmentReport) >= 0)
                {
                    reportSourceOutgoingShipment.Name = "BloodUnitOutgoingShipmentDataSet";
                    reportSourceOutgoingShipment.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.OutgoingShipmentReport];
                }
                e.DataSources.Add(reportSourceOutgoingShipment);
            }
            else if (e.ReportPath == "BloodUnitAntigenTypingHistory" || e.DataSourceNames[0].ToString() == "BloodUnitAntigenTypingDataSet")
            {
                ReportDataSource reportSourceAntigenTyping = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.AntigenTypingReport) >= 0)
                {
                    reportSourceAntigenTyping.Name = "BloodUnitAntigenTypingDataSet";
                    reportSourceAntigenTyping.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.AntigenTypingReport];
                }
                e.DataSources.Add(reportSourceAntigenTyping);
            }
            else if (e.ReportPath == "BloodUnitRestrictedPatientHistory" || e.DataSourceNames[0].ToString() == "BloodUnitRestrictedPatientDataSet")
            {
                ReportDataSource reportSourceRestrictedPatient = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.DirectedPatientReport) >= 0)
                {
                    reportSourceRestrictedPatient.Name = "BloodUnitRestrictedPatientDataSet";
                    reportSourceRestrictedPatient.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.DirectedPatientReport];
                }
                e.DataSources.Add(reportSourceRestrictedPatient);
            }
            else if (e.ReportPath == "BloodUnitStatusHistory" || e.DataSourceNames[0].ToString() == "BloodUnitStatusDataSet")
            {
                ReportDataSource reportSourceStatus = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.StatusReport) >= 0)
                {
                    reportSourceStatus.Name = "BloodUnitStatusDataSet";
                    reportSourceStatus.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.StatusReport];
                }
                e.DataSources.Add(reportSourceStatus);
            }
            else if (e.ReportPath == "BloodUnitFinancialHistory" || e.DataSourceNames[0].ToString() == "BloodUnitFinancialDataSet")
            {
                ReportDataSource reportSourceFinance = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.FinanceReport) >= 0)
                {
                    reportSourceFinance.Name = "BloodUnitFinancialDataSet";
                    reportSourceFinance.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.FinanceReport];
                }
                e.DataSources.Add(reportSourceFinance);
            }
            else if (e.ReportPath == "BloodUnitPatientAssociationHistory" || e.DataSourceNames[0].ToString() == "BloodUnitPatientAssociationDataSet")
            {
                ReportDataSource reportSourcePatientAssociation = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.PatientAssociationReport) >= 0)
                {
                    reportSourcePatientAssociation.Name = "BloodUnitPatientAssociationDataSet";
                    reportSourcePatientAssociation.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.PatientAssociationReport];
                }
                e.DataSources.Add(reportSourcePatientAssociation);
            }
            else if (e.ReportPath == "BloodUnitIssueHistory" || e.DataSourceNames[0].ToString() == "BloodUnitIssueDataSet")
            {
                ReportDataSource reportSourceIssue = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.IssueReport) >= 0)
                {
                    reportSourceIssue.Name = "BloodUnitIssueDataSet";
                    reportSourceIssue.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.IssueReport];
                }
                e.DataSources.Add(reportSourceIssue);
            }
            else if (e.ReportPath == "BloodUnitTestingHistory" || e.DataSourceNames[0].ToString() == "BloodUnitTestingDataSet")
            {
                ReportDataSource reportSourceTesting = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.BloodUnitTestingReport) >= 0)
                {
                    reportSourceTesting.Name = "BloodUnitTestingDataSet";
                    reportSourceTesting.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.BloodUnitTestingReport];
                }
                e.DataSources.Add(reportSourceTesting);
            }
            else if (e.ReportPath == "BloodUnitCrossmatchTestingHistory" || e.DataSourceNames[0].ToString() == "BloodUnitCrossmatchTestingDataSet")
            {
                ReportDataSource reportSourceCrossmatchTesting = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.CrossmatchTestingReport) >= 0)
                {
                    reportSourceCrossmatchTesting.Name = "BloodUnitCrossmatchTestingDataSet";
                    reportSourceCrossmatchTesting.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.CrossmatchTestingReport];
                }
                e.DataSources.Add(reportSourceCrossmatchTesting);
            }
            else if (e.ReportPath == "BloodUnitModificationOriginalUnitsHistory" || e.DataSourceNames[0].ToString() == "BloodUnitModificationOriginalUnitsDataSet")
            {
                ReportDataSource reportSourceOriginalUnits = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.OriginalUnitsFromModification) >= 0)
                {
                    reportSourceOriginalUnits.Name = "BloodUnitModificationOriginalUnitsDataSet";
                    reportSourceOriginalUnits.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.OriginalUnitsFromModification];
                }
                e.DataSources.Add(reportSourceOriginalUnits);
            }
            else if (e.ReportPath == "BloodUnitModificationTargetUnitsHistory" || e.DataSourceNames[0].ToString() == "BloodUnitModificationTargetUnitsDataSet")
            {
                ReportDataSource reportSourceTargetUnits = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.TargetUnitsFromModification) >= 0)
                {
                    reportSourceTargetUnits.Name = "BloodUnitModificationTargetUnitsDataSet";
                    reportSourceTargetUnits.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.TargetUnitsFromModification];
                }
                e.DataSources.Add(reportSourceTargetUnits);
            }
            else if (e.ReportPath == "BloodUnitModificationHistory" || e.DataSourceNames[0].ToString() == "BloodUnitModificationDataSet")
            {
                ReportDataSource reportSourceModification = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.ModificationReport) >= 0)
                {
                    reportSourceModification.Name = "BloodUnitModificationDataSet";
                    reportSourceModification.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.ModificationReport];
                }
                e.DataSources.Add(reportSourceModification);
            }
            else if (e.ReportPath == "BloodUnitModificationEquipmentHistory" || e.DataSourceNames[0].ToString() == "BloodUnitModificationEquipmentDataSet")
            {
                ReportDataSource reportSourceModificationEquipment = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.ModificationEquipmentAndSupplies) >= 0)
                {
                    reportSourceModificationEquipment.Name = "BloodUnitModificationEquipmentDataSet";
                    reportSourceModificationEquipment.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.ModificationEquipmentAndSupplies];
                }
                e.DataSources.Add(reportSourceModificationEquipment);
            }
            else if (e.ReportPath == "BloodUnitTransfusionHistory" || e.DataSourceNames[0].ToString() == "BloodUnitTransfusionDataSet")
            {
                ReportDataSource reportSourceTransfusion = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.DatabaseConstants.BloodUnitReportTables.TransfusionReport) >= 0)
                {
                    reportSourceTransfusion.Name = "BloodUnitTransfusionDataSet";
                    reportSourceTransfusion.Value = _reportData.Tables[Common.DatabaseConstants.BloodUnitReportTables.TransfusionReport];
                }
                e.DataSources.Add(reportSourceTransfusion);
            }
            else if (e.ReportPath == "ExceptionAntigenTest" || e.DataSourceNames[0].ToString() == "ExceptionAntigenTestDataSet")
            {
                ReportDataSource reportSourceExceptionAntigenTest = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionAntigenTest") >= 0)
                {
                    reportSourceExceptionAntigenTest.Name = "ExceptionAntigenTestDataSet";
                    reportSourceExceptionAntigenTest.Value = _reportData.Tables["ExceptionAntigenTest"];
                }
                e.DataSources.Add(reportSourceExceptionAntigenTest);
            }
            else if (e.ReportPath == "ExceptionExpiredUnit" || e.DataSourceNames[0].ToString() == "ExceptionExpiredUnitDataSet")
            {
                ReportDataSource reportSourceExceptionExpiredUnit = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("GetExceptionReportExpiredUnitReceived") >= 0)
                {
                    reportSourceExceptionExpiredUnit.Name = "ExceptionExpiredUnitDataSet";
                    reportSourceExceptionExpiredUnit.Value = _reportData.Tables["GetExceptionReportExpiredUnitReceived"];
                }
                e.DataSources.Add(reportSourceExceptionExpiredUnit);
            }
            else if (e.ReportPath == "ExceptionLabelMismatch" || e.DataSourceNames[0].ToString() == "ExceptionLabelMismatchDataSet")
            {
                ReportDataSource reportSourceExceptionLabelMismatch = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionReportLabelMismatch") >= 0)
                {
                    reportSourceExceptionLabelMismatch.Name = "ExceptionLabelMismatchDataSet";
                    reportSourceExceptionLabelMismatch.Value = _reportData.Tables["ExceptionReportLabelMismatch"];
                }
                e.DataSources.Add(reportSourceExceptionLabelMismatch);
            }
            else if (e.ReportPath == "ExceptionQuarantine" || e.DataSourceNames[0].ToString() == "ExceptionQuarantineDataSet")
            {
                ReportDataSource reportSourceExceptionQuarantine = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionReportQuarantine") >= 0)
                {
                    reportSourceExceptionQuarantine.Name = "ExceptionQuarantineDataSet";
                    reportSourceExceptionQuarantine.Value = _reportData.Tables["ExceptionReportQuarantine"];
                }
                e.DataSources.Add(reportSourceExceptionQuarantine);
            }
            else if (e.ReportPath == "ExceptionRemoveFinalUnitStatus" || e.DataSourceNames[0].ToString() == "ExceptionRemoveFinalUnitStatusDataSet")
            {
                ReportDataSource reportSourceExceptionRemoveFinalUnitStatus = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus.ToString()) >= 0)
                {
                    reportSourceExceptionRemoveFinalUnitStatus.Name = "ExceptionRemoveFinalUnitStatusDataSet";
                    reportSourceExceptionRemoveFinalUnitStatus.Value = _reportData.Tables[Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionRemoveFinalUnitStatus);
            }
            else if (e.ReportPath == "ExceptionReturnIssuedUnit" || e.DataSourceNames[0].ToString() == "ExceptionReturnIssuedUnitDataSet")
            {
                ReportDataSource reportSourceExceptionReturnIssuedUnit = new ReportDataSource();
                if (this._reportData.Tables.IndexOf(Common.ExceptionReportType.ExceptionReportReturnIssuedUnit.ToString()) >= 0)
                {
                    reportSourceExceptionReturnIssuedUnit.Name = "ExceptionReturnIssuedUnitDataSet";
                    reportSourceExceptionReturnIssuedUnit.Value = _reportData.Tables[Common.ExceptionReportType.ExceptionReportReturnIssuedUnit.ToString()];
                }
                e.DataSources.Add(reportSourceExceptionReturnIssuedUnit);
            }
            else if (e.ReportPath == "ExceptionUnitAboRh" || e.DataSourceNames[0].ToString() == "ExceptionUnitAboRhDataSet")
            {
                ReportDataSource reportSourceExceptionUnitAboRh = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionReportUnitAboRh") >= 0)
                {
                    reportSourceExceptionUnitAboRh.Name = "ExceptionUnitAboRhDataSet";
                    reportSourceExceptionUnitAboRh.Value = _reportData.Tables["ExceptionReportUnitAboRh"];
                }
                e.DataSources.Add(reportSourceExceptionUnitAboRh);
            }
            else if (e.ReportPath == "ExceptionUnitModification" || e.DataSourceNames[0].ToString() == "ExceptionUnitModificationDataSet")
            {
                ReportDataSource reportSourceExceptionUnitModification = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionReportUnitModification") >= 0)
                {
                    reportSourceExceptionUnitModification.Name = "ExceptionUnitModificationDataSet";
                    reportSourceExceptionUnitModification.Value = _reportData.Tables["ExceptionReportUnitModification"];
                }
                e.DataSources.Add(reportSourceExceptionUnitModification);
            }
            else if (e.ReportPath == "ExceptionUnitSelection" || e.DataSourceNames[0].ToString() == "ExceptionUnitSelectionDataSet")
            {
                ReportDataSource reportSourceExceptionUnitSelection = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionReportUnitSelection") >= 0)
                {
                    reportSourceExceptionUnitSelection.Name = "ExceptionUnitSelectionDataSet";
                    reportSourceExceptionUnitSelection.Value = _reportData.Tables["ExceptionReportUnitSelection"];
                }
                e.DataSources.Add(reportSourceExceptionUnitSelection);
            }
            else if (e.ReportPath == "ExceptionUnitSupply" || e.DataSourceNames[0].ToString() == "ExceptionUnitSupplyDataSet")
            {
                ReportDataSource reportSourceExceptionUnitSupply = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionReportUnitSupplyForBloodUnit") >= 0)
                {
                    reportSourceExceptionUnitSupply.Name = "ExceptionUnitSupplyDataSet";
                    reportSourceExceptionUnitSupply.Value = _reportData.Tables["ExceptionReportUnitSupplyForBloodUnit"];
                }
                e.DataSources.Add(reportSourceExceptionUnitSupply);
            }
            else if (e.ReportPath == "ExceptionQC" || e.DataSourceNames[0].ToString() == "ExceptionQCDataSet")
            {
                ReportDataSource reportSourceExceptionQC = new ReportDataSource();
                if (this._reportData.Tables.IndexOf("ExceptionReportQC") >= 0)
                {
                    reportSourceExceptionQC.Name = "ExceptionQCDataSet";
                    reportSourceExceptionQC.Value = _reportData.Tables["ExceptionReportQC"];
                }
                e.DataSources.Add(reportSourceExceptionQC);
            }
        }

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/7/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5757"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataSet</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5758"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetReportTables
		/// </summary>
		public DataSet GetReportTables()
		{
			DataSet reportData = DAL.BloodUnitReport.GetHistoricalBloodUnitDataTables
			(
				BloodUnitGuid,
				this.IncludeIncomingShipmentReport,
				this.IncludeOutgoingShipmentReport,
				this.IncludeAntigenTypingReport,
				this.IncludeRestrictedPatientReport,
				this.IncludeStatusReport,
				this.IncludeFinanceReport,
				this.IncludePatientAssociationReport,
				this.IncludeIssueReport,
				this.IncludeBloodUnitTestingReport,
				this.IncludeCrossmatchTestingReport,
				this.IncludeModificationReport,
				this.IncludeTransfusionReport 
			);
			//
			if(reportData.Tables.Count > 0 && reportData.Tables[REPORT_TABLES.BloodUnitHistorySummary].Rows.Count > 0)
			{
				this._exceptionReportRowCount = 0;

				// Handle Exception Reports (mainly done in BOL.ExceptionReport)
				#region Exception Reports
			
				if(this.IncludeExceptionReport)
				{
					// ExceptionReportAntigenTest
					DataSet antigenTest = BOL.ExceptionReport.GetBloodUnitExceptionReport(this.BloodUnitGuid, Common.ExceptionReportType.ExceptionReportAntigenTest);
					if(antigenTest.Tables.Count > 0 && antigenTest.Tables[0].Rows.Count > 0)
					{
						DataTable antigenTestTable = antigenTest.Tables[0].Copy();
						reportData.Tables.Add(antigenTestTable);
						this._exceptionReportRowCount = antigenTest.Tables[0].Rows.Count;
					}
					// ExceptionReportExpiredUnitReceived
					DataSet expiredUnitReceived = BOL.ExceptionReport.GetBloodUnitExceptionReport(this.BloodUnitGuid, Common.ExceptionReportType.ExceptionReportExpiredUnitReceived);
					if(expiredUnitReceived.Tables.Count > 0 && expiredUnitReceived.Tables[0].Rows.Count > 0)
					{
						DataTable expiredUnitReceivedTable = expiredUnitReceived.Tables[0].Copy();
						reportData.Tables.Add(expiredUnitReceivedTable);
						this._exceptionReportRowCount += expiredUnitReceived.Tables[0].Rows.Count;
					}
					//
					// ExceptionReportLabelMismatch
					DataSet labeMismatch = BOL.ExceptionReport.GetBloodUnitExceptionReport(this.BloodUnitGuid, Common.ExceptionReportType.ExceptionReportLabelMismatch);
					if(labeMismatch.Tables.Count > 0 && labeMismatch.Tables[0].Rows.Count > 0)
					{
						DataTable labeMismatchTable = labeMismatch.Tables[0].Copy();
						reportData.Tables.Add(labeMismatchTable);
						this._exceptionReportRowCount += labeMismatch.Tables[0].Rows.Count;
					}
					//
					// ExceptionReportQuarantine
					DataSet quarantine = BOL.ExceptionReport.GetBloodUnitExceptionReport(this.BloodUnitGuid, Common.ExceptionReportType.ExceptionReportQuarantine);
					if(quarantine.Tables.Count > 0 && quarantine.Tables[0].Rows.Count > 0)
					{
						DataTable quarantineTable = quarantine.Tables[0].Copy();
						reportData.Tables.Add(quarantineTable);
						this._exceptionReportRowCount += quarantine.Tables[0].Rows.Count;
					}
					//
					// ExceptionReportRemoveFinalUnitStatus
					DataSet removeFinalStatus = BOL.ExceptionReport.GetBloodUnitExceptionReport(this.BloodUnitGuid, Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus);
					if(removeFinalStatus.Tables.Count > 0 && removeFinalStatus.Tables[0].Rows.Count > 0)
					{
						DataTable removeFinalStatusTable = removeFinalStatus.Tables[0].Copy();
						reportData.Tables.Add(removeFinalStatusTable);
						this._exceptionReportRowCount += removeFinalStatus.Tables[0].Rows.Count;
					}
					//
					// ExceptionReportReturnIssuedUnit
					DataSet returnIssuedUnit = BOL.ExceptionReport.GetBloodUnitExceptionReport(this.BloodUnitGuid, Common.ExceptionReportType.ExceptionReportReturnIssuedUnit);
					if(returnIssuedUnit.Tables.Count > 0 && returnIssuedUnit.Tables[0].Rows.Count > 0)
					{
						DataTable returnIssuedUnitTable = returnIssuedUnit.Tables[0].Copy();
						reportData.Tables.Add(returnIssuedUnitTable);
						this._exceptionReportRowCount += returnIssuedUnit.Tables[0].Rows.Count;
					}
					//
					// ExceptionReportUnitAboRh
					DataSet unitAboRh = BOL.ExceptionReport.GetBloodUnitExceptionReport(this.BloodUnitGuid, Common.ExceptionReportType.ExceptionReportUnitAboRh);
					if(unitAboRh.Tables.Count > 0 && unitAboRh.Tables[0].Rows.Count > 0)
					{
						DataTable unitAboRhTable = unitAboRh.Tables[0].Copy();
						reportData.Tables.Add(unitAboRhTable);
						this._exceptionReportRowCount += unitAboRh.Tables[0].Rows.Count;
					}
					//
					// ExceptionReportUnitModification
					DataSet unitModification = BOL.ExceptionReport.GetBloodUnitExceptionReport(this.BloodUnitGuid, Common.ExceptionReportType.ExceptionReportUnitModification);
					if(unitModification.Tables.Count > 0 && unitModification.Tables[0].Rows.Count > 0)
					{
						DataTable unitModificationTable = unitModification.Tables[0].Copy();
						reportData.Tables.Add(unitModificationTable);
						this._exceptionReportRowCount += unitModification.Tables[0].Rows.Count;
					}
					//
					// ExceptionReportUnitSelection
					DataSet unitSelection = BOL.ExceptionReport.GetBloodUnitExceptionReport(this.BloodUnitGuid, Common.ExceptionReportType.ExceptionReportUnitSelection);
					if(unitSelection.Tables.Count > 0 && unitSelection.Tables[0].Rows.Count > 0)
					{
						DataTable unitSelectionTable = unitSelection.Tables[0].Copy();
						reportData.Tables.Add(unitSelectionTable);
						this._exceptionReportRowCount += unitSelection.Tables[0].Rows.Count;
					}
					//
					// ExceptionReportUnitSupply
					DataSet unitSupply = BOL.ExceptionReport.GetBloodUnitExceptionReport(this.BloodUnitGuid, Common.ExceptionReportType.ExceptionReportUnitSupply);
					if(unitSupply.Tables.Count > 0 && unitSupply.Tables[0].Rows.Count > 0)
					{
						DataTable unitSupplyTable = unitSupply.Tables[0].Copy();
						reportData.Tables.Add(unitSupplyTable);
						this._exceptionReportRowCount += unitSupply.Tables[0].Rows.Count;
					}
					//
					// ExceptionReportQc
					DataSet reagentQc = BOL.ExceptionReport.GetBloodUnitExceptionReport(this.BloodUnitGuid, Common.ExceptionReportType.ExceptionReportQC);
					if(reagentQc.Tables.Count > 0 && reagentQc.Tables[0].Rows.Count > 0)
					{
						DataTable reagentQcTable = reagentQc.Tables[0].Copy();
						reportData.Tables.Add(reagentQcTable);
						this._exceptionReportRowCount += reagentQc.Tables[0].Rows.Count;
					}
				}

				#endregion
			}

			return reportData;
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/22/2004</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="5867"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5868"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Builds report criteria string 
		/// (what subreports were included, etc.)
		/// </summary>
		public string GetReportCriteria()
		{
			StringBuilder builder = new StringBuilder();
			builder.Append("Blood Unit ID = ");
			builder.Append(this.EyeReadableUnitId);
			builder.Append(", Product Code = ");
			builder.Append(this.ProductCode);
            builder.Append(", Requested Reports:\n");
			//
			StringBuilder reports = new StringBuilder();
			reports.Append(this.IncludeAntigenTypingReport ? "Anitgen Typing" : "");
			reports.Append(this.IncludeBloodUnitTestingReport ? (reports.Length > 0 ? ", Blood Unit Testing" : "Blood Unit Testing") : "");
			reports.Append(this.IncludeCrossmatchTestingReport ? (reports.Length > 0 ? ", Crossmatch Testing" : "Crossmatch Testing") : "");
			reports.Append(this.IncludeExceptionReport ? (reports.Length > 0 ? ", Exception" : "Exception") : "");
			reports.Append(this.IncludeFinanceReport ? (reports.Length > 0 ? ", Finance" : "Finance") : "");
			reports.Append(this.IncludeIncomingShipmentReport ? (reports.Length > 0 ? ", Incoming Shipment" : "Incoming Shipment") : "");
			reports.Append(this.IncludeIssueReport ? (reports.Length > 0 ? ", Issue" : "Issue") : "");
			reports.Append(this.IncludeModificationReport ? (reports.Length > 0 ? ", Modification" : "Modification") : "");
			reports.Append(this.IncludeOutgoingShipmentReport ? (reports.Length > 0 ? ", Outgoing Shipment" : "Outgoing Shipment") : "");
			reports.Append(this.IncludePatientAssociationReport ? (reports.Length > 0 ? ", Patient Association" : "Patient Association") : "");
			reports.Append(this.IncludeRestrictedPatientReport ? (reports.Length > 0 ? ", Restricted Patient" : "Restricted Patient") : "");
			reports.Append(this.IncludeStatusReport ? (reports.Length > 0 ? ", Quarantine" : "Quarantine") : "");
			reports.Append(this.IncludeTransfusionReport ? (reports.Length > 0 ? ", Transfusion" : "Transfusion") : "");
			reports.Append(".");
			builder.Append(reports);
			//
			builder.Append("\n\n");
			builder.Append(this._message);
			//
			return builder.ToString();
		}

		/// <summary>
		/// SectionRequested
		/// </summary>
		private bool SectionRequested(string reportName)
		{	
			switch(reportName)
			{
				case "AntigenTypingReport":						{ return IncludeAntigenTypingReport; }
				case "BloodUnitTestingReport":					{ return IncludeBloodUnitTestingReport; }
				case "CrossmatchTestingReport":					{ return IncludeCrossmatchTestingReport; }
				case "DirectedPatientReport":					{ return IncludeRestrictedPatientReport; }
				case "FinanceReport":							{ return IncludeFinanceReport; }
				case "IncomingShipmentReport":					{ return IncludeIncomingShipmentReport; }
				case "IssueReport":								{ return IncludeIssueReport; }
				case "ModificationReport":						{ return IncludeModificationReport; }
				case "OriginalUnitsFromModification":			{ return IncludeModificationReport; }
				case "TargetUnitsFromModification":				{ return IncludeModificationReport; }
				case "ModificationEquipmentAndSupplies":		{ return IncludeModificationReport; }
				case "OutgoingShipmentReport":					{ return IncludeOutgoingShipmentReport; }
				case "PatientAssociationReport":				{ return IncludePatientAssociationReport; }
				case "StatusReport":							{ return IncludeStatusReport; }
				case "TransfusionReport":						{ return IncludeTransfusionReport; }
				case "GetExceptionReportExpiredUnitReceived":	{ return IncludeExceptionReport; }
				case "ExceptionReportAntigenTest":				{ return IncludeExceptionReport; }
				case "ExceptionReportLabelMismatch":			{ return IncludeExceptionReport; }
				case "ExceptionReportQuarantine":				{ return IncludeExceptionReport; }
				case "ExceptionReportRemoveFinalUnitStatus":	{ return IncludeExceptionReport; }
				case "ExceptionReportReturnIssuedUnit":			{ return IncludeExceptionReport; }
				case "ExceptionReportUnitAboRH":				{ return IncludeExceptionReport; }
				case "ExceptionReportUnitSelection":			{ return IncludeExceptionReport; }
				case "ExceptionReportUnitModification":			{ return IncludeExceptionReport; }
				case "ExceptionReportUnitSupply":				{ return IncludeExceptionReport; }
				case "ExceptionReportQC":						{ return IncludeExceptionReport; }
				default:										{ return false; }
			}
		}

		/// <summary>
		/// SectionRequested
		/// </summary>
		private string GetSectionDisplayName(string reportName)
		{
			switch(reportName)
			{
				case "AntigenTypingReport":						{ return "Anitgen Typing"; }
				case "BloodUnitTestingReport":					{ return "Blood Unit Testing" ; }
				case "CrossmatchTestingReport":					{ return "Crossmatch Testing"; }
				case "DirectedPatientReport":					{ return "Restricted Patient"; }
				case "FinanceReport":							{ return "Finance"; }
				case "IncomingShipmentReport":					{ return "Incoming Shipment"; }
				case "IssueReport":								{ return "Issue"; }
				case "ModificationReport":						{ return "Modification"; }
				case "OriginalUnitsFromModification":			{ return "Modification"; }
				case "TargetUnitsFromModification":				{ return "Modification"; }
				case "ModificationEquipmentAndSupplies":		{ return "Modification"; }
				case "OutgoingShipmentReport":					{ return "Outgoing Shipment"; }
				case "PatientAssociationReport":				{ return "Patient Association"; }
				case "StatusReport":							{ return "Quarantine"; }
				case "TransfusionReport":						{ return "Transfusion"; }
				default:										{ return string.Empty; }
			}
		}

		#endregion
	}
}